[

define_tag:'lp_string_linefeedSet',
	-description='Standardizes the line endings in a string.',
	-priority='replace',
	-required='string',
	-optional='line_ending';

	// usage: [lp_string_linefeedSet: $mystring, '\r'] to convert the line endings to \r
	//
	// or optionally leave off the line ending for \r\n	
	

	local:'return' = string: #string;

	// default line ending is RFC line ending
	if: !(local_defined:'line_ending');
		local:'line_ending' = '\r\n';
	/if;

	// first, standarize the line ending to \r
	#return->(replace:'\r\n','\r');
	#return->(replace:'\n','\r');

	// now replace with line ending requested
	#return->(replace:'\r',#line_ending);
	
	return: @#return;

	/* Example
	
	[var:'test' = 'line_1\rline_2\nline_3\r\n']
	<pre>
	Before: [output: $test,-encodeurl]
	
	After: [output: (lp_string_linefeedSet:$test,'\r'),-encodeurl]
	</pre>
	
	*/

/define_tag;

]
